﻿using Harmony;
using RimWorld;
using RimWorld.BaseGen;
using RimWorld.Planet;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using UnityEngine;
using Verse;
using Verse.AI;
using Verse.Noise;

namespace RFR_Code {
	
	public class Controller_Terrain : Mod {
		public static Settings_Terrain Settings;
		public static bool detectedFertileFields = false;
		public static float coastLevelSetting = -1;
		public static float geysersLevelSetting = -1;
		public static float chunksLevelSetting = -1;
		public static float oreLevelSetting = -1;
		public static float waterLevelSetting = -1;
		public static float fertilityLevelSetting = -1;
		public static float mountainLevelSetting = -1;
		public override string SettingsCategory() { return "RFR.FewerRuinsTerrain".Translate(); }
		public override void DoSettingsWindowContents(Rect canvas) { Settings.DoWindowContents(canvas); }
		public Controller_Terrain(ModContentPack content) : base(content) {
			HarmonyInstance harmony = HarmonyInstance.Create("net.rainbeau.rimworld.mod.fewerruins");
			harmony.PatchAll( Assembly.GetExecutingAssembly() );
			Settings = GetSettings<Settings_Terrain>();
			if (ModsConfig.ActiveModsInLoadOrder.Any(mod => mod.Name.Contains("[RF] Fertile Fields"))) {
				detectedFertileFields = true;
			}
		}
	}

	public class Controller_Things : Mod {
		public static Settings_Things Settings;
		public static float animalDensityLevelSetting = -1;
		public static float plantDensityLevelSetting = -1;
		public static float ruinsLevelSetting = -1;
		public static float shrinesLevelSetting = -1;
		public static float stoneTypeSetting = -1;
		public override string SettingsCategory() { return "RFR.FewerRuinsThings".Translate(); }
		public override void DoSettingsWindowContents(Rect canvas) { Settings.DoWindowContents(canvas); }
		public Controller_Things(ModContentPack content) : base(content) {
			Settings = GetSettings<Settings_Things>();
		}
	}

	public class Controller_World : Mod {
		public static Settings_World Settings;
		public override string SettingsCategory() { return "RFR.FewerRuinsWorld".Translate(); }
		public override void DoSettingsWindowContents(Rect canvas) { Settings.DoWindowContents(canvas); }
		public Controller_World(ModContentPack content) : base(content) {
			Settings = GetSettings<Settings_World>();
		}
	}

	public class Settings_Terrain : ModSettings {
		public float coastLevel = 0.5f;
		public float geysersLevel = 2.5f;
		public float chunksLevel = 2.5f;
		public float oreLevel = 2.5f;
		public float fertilityLevel = 2.5f;
		public float waterLevel = 2.5f;
		public float mountainLevel = 2.5f;
		public bool disallowIslands = false;
		public void DoWindowContents(Rect canvas) {
			Listing_Standard list = new Listing_Standard();
			list.ColumnWidth = canvas.width;
			list.Begin(canvas);
			// ----------------- //
			// -- Ore Density -- //
			// ----------------- //
			list.Gap();
			if (oreLevel < 1) { list.Label("RFR.oreLevel".Translate()+"  "+"RFR.OreNone".Translate()); }
			else if (oreLevel < 2) { list.Label("RFR.oreLevel".Translate()+"  "+"RFR.OreLow".Translate()); }
			else if (oreLevel < 3) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.oreLevel".Translate()+"  "+"RFR.OreNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else if (oreLevel < 4) { list.Label("RFR.oreLevel".Translate()+"  "+"RFR.OreHigh".Translate()); }
			else if (oreLevel < 5) { list.Label("RFR.oreLevel".Translate()+"  "+"RFR.OreVeryHigh".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.oreLevel".Translate()+"  "+"RFR.OreRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			oreLevel = list.Slider(oreLevel, 0, 6);
			// ----------------------- //
			// -- Number of Geysers -- //
			// ----------------------- //
			list.Gap();
			if (geysersLevel < 1) { list.Label("RFR.geysersLevel".Translate()+"  "+"RFR.GeysersNone".Translate()); }
			else if (geysersLevel < 2) { list.Label("RFR.geysersLevel".Translate()+"  "+"RFR.GeysersLow".Translate()); }
			else if (geysersLevel < 3) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.geysersLevel".Translate()+"  "+"RFR.GeysersNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else if (geysersLevel < 4) { list.Label("RFR.geysersLevel".Translate()+"  "+"RFR.GeysersHigh".Translate()); }
			else if (geysersLevel < 5) { list.Label("RFR.geysersLevel".Translate()+"  "+"RFR.GeysersVeryHigh".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.geysersLevel".Translate()+"  "+"RFR.GeysersRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			geysersLevel = list.Slider(geysersLevel, 0, 6);
			// ---------------------------- //
			// -- Number of Stone Chunks -- //
			// ---------------------------- //
			list.Gap();
			if (chunksLevel < 1) { list.Label("RFR.chunksLevel".Translate()+"  "+"RFR.ChunksNone".Translate()); }
			else if (chunksLevel < 2) { list.Label("RFR.chunksLevel".Translate()+"  "+"RFR.ChunksLow".Translate()); }
			else if (chunksLevel < 3) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.chunksLevel".Translate()+"  "+"RFR.ChunksNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.chunksLevel".Translate()+"  "+"RFR.ChunksRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			chunksLevel = list.Slider(chunksLevel, 0, 4);
			// -------------------- //
			// -- Mountain Level -- //
			// -------------------- //
			list.Gap();
			if (mountainLevel < 1) { list.Label("RFR.mountainLevel".Translate()+"  "+"RFR.MountainVeryLow".Translate()); }
			else if (mountainLevel < 2) { list.Label("RFR.mountainLevel".Translate()+"  "+"RFR.MountainLow".Translate()); }
			else if (mountainLevel < 3) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.mountainLevel".Translate()+"  "+"RFR.MountainNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else if (mountainLevel < 4) { list.Label("RFR.mountainLevel".Translate()+"  "+"RFR.MountainHigh".Translate()); }
			else if (mountainLevel < 5) { list.Label("RFR.mountainLevel".Translate()+"  "+"RFR.MountainVeryHigh".Translate()); }
			else if (mountainLevel < 6) { list.Label("RFR.mountainLevel".Translate()+"  "+"RFR.MountainInsane".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.mountainLevel".Translate()+"  "+"RFR.MountainRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			mountainLevel = list.Slider(mountainLevel, 0, 7);
			// ----------------- //
			// -- Water Level -- //
			// ----------------- //
			list.Gap();
			if (waterLevel < 1) { list.Label("RFR.waterLevel".Translate()+"  "+"RFR.WaterVeryLow".Translate()); }
			else if (waterLevel < 2) { list.Label("RFR.waterLevel".Translate()+"  "+"RFR.WaterLow".Translate()); }
			else if (waterLevel < 3) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.waterLevel".Translate()+"  "+"RFR.WaterNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else if (waterLevel < 4) { list.Label("RFR.waterLevel".Translate()+"  "+"RFR.WaterHigh".Translate()); }
			else if (waterLevel < 5) { list.Label("RFR.waterLevel".Translate()+"  "+"RFR.WaterVeryHigh".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.waterLevel".Translate()+"  "+"RFR.WaterRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			waterLevel = list.Slider(waterLevel, 0, 6);
			// -------------------- //
			// -- Soil Fertility -- //
			// -------------------- //
			list.Gap();
			if (fertilityLevel < 1) { list.Label("RFR.fertilityLevel".Translate()+"  "+"RFR.FertilityNone".Translate()); }
			else if (fertilityLevel < 2) { list.Label("RFR.fertilityLevel".Translate()+"  "+"RFR.FertilityLow".Translate()); }
			else if (fertilityLevel < 3) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.fertilityLevel".Translate()+"  "+"RFR.FertilityNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else if (fertilityLevel < 4) { list.Label("RFR.fertilityLevel".Translate()+"  "+"RFR.FertilityHigh".Translate()); }
			else if (fertilityLevel < 5) { list.Label("RFR.fertilityLevel".Translate()+"  "+"RFR.FertilityVeryHigh".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.fertilityLevel".Translate()+"  "+"RFR.FertilityRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			fertilityLevel = list.Slider(fertilityLevel, 0, 6);
			// ----------------- //
			// -- Coast Level -- //
			// ----------------- //
			list.Gap();
			if (coastLevel < 1) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.coastLevel".Translate()+"  "+"RFR.CoastNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else if (coastLevel < 2) { list.Label("RFR.coastLevel".Translate()+"  "+"RFR.CoastHigh1".Translate()); }
			else if (coastLevel < 3) { list.Label("RFR.coastLevel".Translate()+"  "+"RFR.CoastHigh2".Translate()); }
			else if (coastLevel < 4) { list.Label("RFR.coastLevel".Translate()+"  "+"RFR.CoastVeryHigh1".Translate()); }
			else if (coastLevel < 5) { list.Label("RFR.coastLevel".Translate()+"  "+"RFR.CoastVeryHigh2".Translate()); }
			else if (coastLevel < 6) { list.Label("RFR.coastLevel".Translate()+"  "+"RFR.CoastVeryHigh3".Translate()); }
			else if (coastLevel < 7) { list.Label("RFR.coastLevel".Translate()+"  "+"RFR.CoastInsane".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.coastLevel".Translate()+"  "+"RFR.CoastRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			coastLevel = list.Slider(coastLevel, 0, 8);
			list.Gap();
			list.CheckboxLabeled( "RFR.DisallowIslands".Translate(), ref disallowIslands, "RFR.DisallowIslandsTip".Translate() );
			list.End();
		}
		public override void ExposeData() {
			base.ExposeData();
			Scribe_Values.Look(ref coastLevel, "coastLevel", 0.5f);
			Scribe_Values.Look(ref geysersLevel, "geysersLevel", 2.5f);
			Scribe_Values.Look(ref chunksLevel, "chunksLevel", 2.5f);
			Scribe_Values.Look(ref oreLevel, "oreLevel", 2.5f);
			Scribe_Values.Look(ref waterLevel, "waterLevel", 2.5f);
			Scribe_Values.Look(ref fertilityLevel, "fertilityLevel", 2.5f);
			Scribe_Values.Look(ref mountainLevel, "mountainLevel", 2.5f);
			Scribe_Values.Look(ref disallowIslands, "disallowIslands", false);
			Controller_Terrain.coastLevelSetting = -1;
			Controller_Terrain.geysersLevelSetting = -1;
			Controller_Terrain.chunksLevelSetting = -1;
			Controller_Terrain.oreLevelSetting = -1;
			Controller_Terrain.waterLevelSetting = -1;
			Controller_Terrain.fertilityLevelSetting = -1;
			Controller_Terrain.mountainLevelSetting = -1;
		}
	}

	public class Settings_Things : ModSettings {
		public float animalDensityLevel = 1.5f;
		public float plantDensityLevel = 1.5f;
		public float ruinsLevel = 1.5f;
		public float shrinesLevel = 1.5f;
		public float stoneType = 0.5f;
		public void DoWindowContents(Rect canvas) {
			Listing_Standard list = new Listing_Standard();
			list.ColumnWidth = canvas.width;
			list.Begin(canvas);
			// ---------------------- //
			// -- Density of Ruins -- //
			// ---------------------- //
			list.Gap();
			if (ruinsLevel < 1) { list.Label("RFR.ruinsLevel".Translate()+"  "+"RFR.RuinsNone".Translate()); }
			else if (ruinsLevel < 2) { list.Label("RFR.ruinsLevel".Translate()+"  "+"RFR.RuinsVeryLow".Translate()); }
			else if (ruinsLevel < 3) { list.Label("RFR.ruinsLevel".Translate()+"  "+"RFR.RuinsLow".Translate()); }
			else if (ruinsLevel < 4) { 
				GUI.contentColor = Color.yellow;
				list.Label("RFR.ruinsLevel".Translate()+"  "+"RFR.RuinsNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else if (ruinsLevel < 5) { list.Label("RFR.ruinsLevel".Translate()+"  "+"RFR.RuinsHigh".Translate()); }
			else if (ruinsLevel < 6) { list.Label("RFR.ruinsLevel".Translate()+"  "+"RFR.RuinsVeryHigh".Translate()); }
			else if (ruinsLevel < 7) { list.Label("RFR.ruinsLevel".Translate()+"  "+"RFR.RuinsExtreme".Translate()); }
			else if (ruinsLevel < 8) { list.Label("RFR.ruinsLevel".Translate()+"  "+"RFR.RuinsInsane".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.ruinsLevel".Translate()+"  "+"RFR.RuinsRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			ruinsLevel = list.Slider(ruinsLevel, 0, 9);
			// ------------------------ //
			// -- Density of Shrines -- //
			// ------------------------ //
			list.Gap();
			if (shrinesLevel < 1) { list.Label("RFR.shrinesLevel".Translate()+"  "+"RFR.ShrinesNone".Translate()); }
			else if (shrinesLevel < 2) { list.Label("RFR.shrinesLevel".Translate()+"  "+"RFR.ShrinesVeryLow".Translate()); }
			else if (shrinesLevel < 3) { list.Label("RFR.shrinesLevel".Translate()+"  "+"RFR.ShrinesLow".Translate()); }
			else if (shrinesLevel < 4) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.shrinesLevel".Translate()+"  "+"RFR.ShrinesNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else if (shrinesLevel < 5) { list.Label("RFR.shrinesLevel".Translate()+"  "+"RFR.ShrinesHigh".Translate()); }
			else if (shrinesLevel < 6) { list.Label("RFR.shrinesLevel".Translate()+"  "+"RFR.ShrinesVeryHigh".Translate()); }
			else if (shrinesLevel < 7) { list.Label("RFR.shrinesLevel".Translate()+"  "+"RFR.ShrinesExtreme".Translate()); }
			else if (shrinesLevel < 8) { list.Label("RFR.shrinesLevel".Translate()+"  "+"RFR.ShrinesInsane".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.shrinesLevel".Translate()+"  "+"RFR.ShrinesRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			shrinesLevel = list.Slider(shrinesLevel, 0, 9);
			// ---------------------- //
			// -- Ruins Stone Type -- //
			// ---------------------- //
			list.Gap();
			if (stoneType < 1) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.stoneType".Translate()+"  "+"RFR.StoneVanilla".Translate());
				GUI.contentColor = Color.white;
			}
			else if (stoneType < 2) { list.Label("RFR.stoneType".Translate()+"  "+"RFR.StoneMixed".Translate()); }
			else if (stoneType < 3) { list.Label("RFR.stoneType".Translate()+"  "+"RFR.StoneLocal".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.stoneType".Translate()+"  "+"RFR.StoneRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			stoneType = list.Slider(stoneType, 0, 4);
			// -------------------- //
			// -- Animal Density -- //
			// -------------------- //
			list.Gap();
			if (animalDensityLevel < 1) { list.Label("RFR.animalDensityLevel".Translate()+"  "+"RFR.AnimalDensitySparse".Translate()); }
			else if (animalDensityLevel < 2) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.animalDensityLevel".Translate()+"  "+"RFR.AnimalDensityNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else if (animalDensityLevel < 3) { list.Label("RFR.animalDensityLevel".Translate()+"  "+"RFR.AnimalDensityDense".Translate()); }
			else if (animalDensityLevel < 4) { list.Label("RFR.animalDensityLevel".Translate()+"  "+"RFR.AnimalDensityExtreme".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.animalDensityLevel".Translate()+"  "+"RFR.AnimalDensityRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			animalDensityLevel = list.Slider(animalDensityLevel, 0, 5);
			// ------------------- //
			// -- Plant Density -- //
			// ------------------- //
			list.Gap();
			if (plantDensityLevel < 1) { list.Label("RFR.plantDensityLevel".Translate()+"  "+"RFR.PlantDensitySparse".Translate()); }
			else if (plantDensityLevel < 2) {
				GUI.contentColor = Color.yellow;
				list.Label("RFR.plantDensityLevel".Translate()+"  "+"RFR.PlantDensityNormal".Translate());
				GUI.contentColor = Color.white;
			}
			else if (plantDensityLevel < 3) { list.Label("RFR.plantDensityLevel".Translate()+"  "+"RFR.PlantDensityDense".Translate()); }
			else if (plantDensityLevel < 4) { list.Label("RFR.plantDensityLevel".Translate()+"  "+"RFR.PlantDensityExtreme".Translate()); }
			else {
				GUI.contentColor = Color.cyan;
				list.Label("RFR.plantDensityLevel".Translate()+"  "+"RFR.PlantDensityRandom".Translate()); 
				GUI.contentColor = Color.white;
			}
			plantDensityLevel = list.Slider(plantDensityLevel, 0, 5);
			list.End();
		}
		public override void ExposeData() {
			base.ExposeData();
			Scribe_Values.Look(ref animalDensityLevel, "animalDensityLevel", 1.5f);
			Scribe_Values.Look(ref plantDensityLevel, "plantDensityLevel", 1.5f);
			Scribe_Values.Look(ref ruinsLevel, "ruinsLevel", 1.5f);
			Scribe_Values.Look(ref shrinesLevel, "shrinesLevel", 1.5f);
			Scribe_Values.Look(ref stoneType, "stoneType", 0.5f);
			Controller_Things.animalDensityLevelSetting = -1;
			Controller_Things.plantDensityLevelSetting = -1;
			Controller_Things.ruinsLevelSetting = -1;
			Controller_Things.shrinesLevelSetting = -1;
			Controller_Things.stoneTypeSetting = -1;
		}
	}

	public class Settings_World : ModSettings {
		public float stoneMin = 2.5f;
		public float stoneMax = 3.5f;
		public float graniteCommonality = 2.5f;
		public float limestoneCommonality = 2.5f;
		public float marbleCommonality = 2.5f;
		public float sandstoneCommonality = 2.5f;
		public float slateCommonality = 2.5f;
		public float extraStoneCommonality = 2.5f;
		public void DoWindowContents(Rect canvas) {
			Listing_Standard list = new Listing_Standard();
			list.ColumnWidth = canvas.width;
			list.Begin(canvas);
			list.Gap();
			list.Label("RFR.stoneMin".Translate()+"  "+(int)stoneMin);
			stoneMin = list.Slider(stoneMin, 1, 5.99f);
			list.Label("RFR.stoneMax".Translate()+"  "+(int)stoneMax);
			stoneMax = list.Slider(stoneMax, 1, 5.99f);
			Text.Font = GameFont.Tiny;
			list.Label("RFR.stoneNotes".Translate());
			Text.Font = GameFont.Small;
			list.Gap(24);
			if (graniteCommonality < 1) { list.Label("RFR.graniteCommonality".Translate()+"  "+"RFR.Rare".Translate()); }
			else if (graniteCommonality < 2) { list.Label("RFR.graniteCommonality".Translate()+"  "+"RFR.Average".Translate()); }
			else { list.Label("RFR.graniteCommonality".Translate()+"  "+"RFR.Common".Translate()); }
			graniteCommonality = list.Slider(graniteCommonality, 0, 3);
			if (limestoneCommonality < 1) { list.Label("RFR.limestoneCommonality".Translate()+"  "+"RFR.Rare".Translate()); }
			else if (limestoneCommonality < 2) { list.Label("RFR.limestoneCommonality".Translate()+"  "+"RFR.Average".Translate()); }
			else { list.Label("RFR.limestoneCommonality".Translate()+"  "+"RFR.Common".Translate()); }
			limestoneCommonality = list.Slider(limestoneCommonality, 0, 3);
			if (marbleCommonality < 1) { list.Label("RFR.marbleCommonality".Translate()+"  "+"RFR.Rare".Translate()); }
			else if (marbleCommonality < 2) { list.Label("RFR.marbleCommonality".Translate()+"  "+"RFR.Average".Translate()); }
			else { list.Label("RFR.marbleCommonality".Translate()+"  "+"RFR.Common".Translate()); }
			marbleCommonality = list.Slider(marbleCommonality, 0, 3);
			if (sandstoneCommonality < 1) { list.Label("RFR.sandstoneCommonality".Translate()+"  "+"RFR.Rare".Translate()); }
			else if (sandstoneCommonality < 2) { list.Label("RFR.sandstoneCommonality".Translate()+"  "+"RFR.Average".Translate()); }
			else { list.Label("RFR.sandstoneCommonality".Translate()+"  "+"RFR.Common".Translate()); }
			sandstoneCommonality = list.Slider(sandstoneCommonality, 0, 3);
			if (slateCommonality < 1) { list.Label("RFR.slateCommonality".Translate()+"  "+"RFR.Rare".Translate()); }
			else if (slateCommonality < 2) { list.Label("RFR.slateCommonality".Translate()+"  "+"RFR.Average".Translate()); }
			else { list.Label("RFR.slateCommonality".Translate()+"  "+"RFR.Common".Translate()); }
			slateCommonality = list.Slider(slateCommonality, 0, 3);
			list.Gap();
			if (extraStoneCommonality < 1) { list.Label("RFR.extraStoneCommonality".Translate()+"  "+"RFR.Rare".Translate()); }
			else if (extraStoneCommonality < 2) { list.Label("RFR.extraStoneCommonality".Translate()+"  "+"RFR.Average".Translate()); }
			else { list.Label("RFR.extraStoneCommonality".Translate()+"  "+"RFR.Common".Translate()); }
			extraStoneCommonality = list.Slider(extraStoneCommonality, 0, 3);
			list.End();
		}
		public override void ExposeData() {
			base.ExposeData();
			Scribe_Values.Look(ref stoneMin, "stoneMin", 2.5f);
			if (stoneMax < stoneMin) { stoneMax = stoneMin; }
			Scribe_Values.Look(ref stoneMax, "stoneMax", 3.5f);
			Scribe_Values.Look(ref graniteCommonality, "graniteCommonality", 2.5f);
			Scribe_Values.Look(ref limestoneCommonality, "limestoneCommonality", 2.5f);
			Scribe_Values.Look(ref marbleCommonality, "marbleCommonality", 2.5f);
			Scribe_Values.Look(ref sandstoneCommonality, "sandstoneCommonality", 2.5f);
			Scribe_Values.Look(ref slateCommonality, "slateCommonality", 2.5f);
			Scribe_Values.Look(ref extraStoneCommonality, "extraStoneCommonality", 2.5f);
		}
	}

	[HarmonyPatch(typeof(GenStep_RockChunks), "GrowLowRockFormationFrom", null)]
	public static class GenStep_RockChunks_GrowLowRockFormationFrom {
		public static bool Prefix() {
			if (Controller_Terrain.chunksLevelSetting < 0) {
				Controller_Terrain.chunksLevelSetting = Controller_Terrain.Settings.chunksLevel;
				if (Controller_Terrain.chunksLevelSetting > 3) {
					Controller_Terrain.chunksLevelSetting = (Rand.Value)*3;
				}
			}
			if (Controller_Terrain.chunksLevelSetting < 1) { return false; }
			if (Controller_Terrain.chunksLevelSetting < 2) { 
				if (Rand.Value < 0.5f) { return false; } 
			}
			return true;
		}
	}
		
	[HarmonyPatch(typeof(GenStep_Plants), "Generate", null)]
	public static class GenStep_Plants_Generate {
		public static bool Prefix(Map map) {
			if ((Controller_Things.animalDensityLevelSetting < 0) || (Controller_Things.plantDensityLevelSetting < 0)) {
				SetBiodensity.SetBiodensityLevels();
			}
			return true;
		}
	}

	[HarmonyPatch(typeof(GenPlantReproduction), "TryFindReproductionDestination", null)]
	public static class GenPlantReproduction_TryFindReproductionDestination {
		public static bool Prefix(Map map) {
			if ((Controller_Things.animalDensityLevelSetting < 0) || (Controller_Things.plantDensityLevelSetting < 0)) {
				SetBiodensity.SetBiodensityLevels();
			}
			return true;
		}
	}
	
	public static class SetBiodensity {
		public static void SetBiodensityLevels() {
			Controller_Things.animalDensityLevelSetting = Controller_Things.Settings.animalDensityLevel;
			if (Controller_Things.animalDensityLevelSetting > 4) {
				Controller_Things.animalDensityLevelSetting = (Rand.Value)*4;
			}
			float animalModifier = 1;
			if (Controller_Things.animalDensityLevelSetting < 1) { animalModifier = 0.5f; }
			else if (Controller_Things.animalDensityLevelSetting < 2) { }
			else if (Controller_Things.animalDensityLevelSetting < 3) { animalModifier = 2; }
			else { animalModifier = 4; }
			Controller_Things.plantDensityLevelSetting = Controller_Things.Settings.plantDensityLevel;
			if (Controller_Things.plantDensityLevelSetting > 4) {
				Controller_Things.plantDensityLevelSetting = (Rand.Value)*4;
			}
			float plantModifier = 1;
			if (Controller_Things.plantDensityLevelSetting < 1) { plantModifier = 0.5f; }
			else if (Controller_Things.plantDensityLevelSetting < 2) { }
			else if (Controller_Things.plantDensityLevelSetting < 3) { plantModifier = 2; }
			else { plantModifier = 4; }
			BiomeDefOf.AridShrubland.animalDensity = 1.3f * animalModifier;
			BiomeDefOf.AridShrubland.plantDensity = 0.16f * plantModifier;
			BiomeDefOf.BorealForest.animalDensity = 1.9f * animalModifier;
			BiomeDefOf.BorealForest.plantDensity = 0.3f * plantModifier;
			BiomeDef.Named("ColdBog").animalDensity = 0.8f * animalModifier;
			BiomeDef.Named("ColdBog").plantDensity = 0.52f * plantModifier;
			BiomeDefOf.Desert.animalDensity = 0.25f * animalModifier;
			BiomeDefOf.Desert.plantDensity = 0.05f * plantModifier;
			BiomeDef.Named("ExtremeDesert").animalDensity = 0.05f * animalModifier;
			BiomeDef.Named("ExtremeDesert").plantDensity = 0.002f * plantModifier;
			BiomeDefOf.IceSheet.animalDensity = 0.1f * animalModifier;
			BiomeDefOf.IceSheet.plantDensity = 0f * plantModifier;
			BiomeDefOf.SeaIce.animalDensity = 0.05f * animalModifier;
			BiomeDefOf.SeaIce.plantDensity = 0f * plantModifier;
			BiomeDefOf.TemperateForest.animalDensity = 2.8f * animalModifier;
			BiomeDefOf.TemperateForest.plantDensity = 0.55f * plantModifier;
			BiomeDef.Named("TemperateSwamp").animalDensity = 2.8f * animalModifier;
			BiomeDef.Named("TemperateSwamp").plantDensity = 0.55f * plantModifier;
			BiomeDefOf.TropicalRainforest.animalDensity = 4.0f * animalModifier;
			BiomeDefOf.TropicalRainforest.plantDensity = 0.85f * plantModifier;
			BiomeDef.Named("TropicalSwamp").animalDensity = 4.0f * animalModifier;
			BiomeDef.Named("TropicalSwamp").plantDensity = 0.85f * plantModifier;
			BiomeDefOf.Tundra.animalDensity = 0.8f * animalModifier;
			BiomeDefOf.Tundra.plantDensity = 0.14f * plantModifier;
			List<BiomeDef> Biomes = DefDatabase<BiomeDef>.AllDefsListForReading;
			for (int i = Biomes.Count-1; i >= 0; i--) {
				if (Biomes[i].defName.Contains("BorealArchi")) {
					Biomes[i].animalDensity = 1.9f * animalModifier;
					Biomes[i].plantDensity = 0.3f * plantModifier;
				}
				if (Biomes[i].defName.Contains("DesertArchi")) {
					Biomes[i].animalDensity = 1.3f * animalModifier;
					Biomes[i].plantDensity = 0.16f * plantModifier;
				}
				if (Biomes[i].defName.Contains("TemperateArchi")) {
					Biomes[i].animalDensity = 2.8f * animalModifier;
					Biomes[i].plantDensity = 0.55f * plantModifier;
				}
				if (Biomes[i].defName.Contains("TropicalArchi")) {
					Biomes[i].animalDensity = 4.0f * animalModifier;
					Biomes[i].plantDensity = 0.85f * plantModifier;
				}
				if (Biomes[i].defName.Contains("TundraArchi")) {
					Biomes[i].animalDensity = 0.8f * animalModifier;
					Biomes[i].plantDensity = 0.14f * plantModifier;
				}
				if (Biomes[i].defName.Contains("ColdBogArchi")) {
					Biomes[i].animalDensity = 0.8f * animalModifier;
					Biomes[i].plantDensity = 0.52f * plantModifier;
				}
				if (Biomes[i].defName.Contains("TemperateSwampArchi")) {
					Biomes[i].animalDensity = 2.8f * animalModifier;
					Biomes[i].plantDensity = 0.55f * plantModifier;
				}
				if (Biomes[i].defName.Contains("TropicalSwampArchi")) {
					Biomes[i].animalDensity = 4.0f * animalModifier;
					Biomes[i].plantDensity = 0.85f * plantModifier;
				}
				if (Biomes[i].defName == "Cave") {
					Biomes[i].animalDensity = 3.0f * animalModifier;
					Biomes[i].plantDensity = 0f * plantModifier;
				}
			}
		}
	}

	[HarmonyPatch(typeof(GenStep_ScatterRuinsSimple), "ScatterAt", null)]
	public static class GenStep_ScatterRuinsSimple_ScatterAt {
		public static bool Prefix(IntVec3 c, Map map) {
			BaseGen.globalSettings.map = map;
			ThingDef thingDef = BaseGenUtility.RandomCheapWallStuff(null, true);
			if (Rand.Value < 0.9f) {
				int sizeX = Rand.Range(5, 11);
				int sizeZ = Rand.Range(5, 11);
				CellRect cellRect = new CellRect(c.x, c.z, sizeX, sizeZ);
				CellRect cellRect1 = cellRect.ClipInsideMap(map);
				MethodInfo locationCheck = typeof(GenStep_ScatterRuinsSimple).GetMethod("CanPlaceAncientBuildingInRange", BindingFlags.NonPublic | BindingFlags.Instance);
				bool b = (bool) locationCheck.Invoke(new GenStep_ScatterRuinsSimple(), new object[] {cellRect1, map});
				if (b.Equals(true)) {
					BaseGen.symbolStack.Push("ancientRuins", cellRect1);
					BaseGen.Generate();
				}
			}
			else {
				bool flag = Rand.Bool;
				int randomInRange = Rand.Range(3, 11);
                CellRect cellRect2 = new CellRect(c.x, c.z, (!flag ? 1 : randomInRange), (!flag ? randomInRange : 1));
				MethodInfo locationCheck = typeof(GenStep_ScatterRuinsSimple).GetMethod("CanPlaceAncientBuildingInRange", BindingFlags.NonPublic | BindingFlags.Instance);
				bool b = (bool) locationCheck.Invoke(new GenStep_ScatterRuinsSimple(), new object[] {cellRect2.ExpandedBy(1), map});
				if (b.Equals(true)) {
					typeof(GenStep_ScatterRuinsSimple).GetMethod("MakeLongWall", BindingFlags.NonPublic | BindingFlags.Instance).Invoke(new GenStep_ScatterRuinsSimple(), new object[] {c, map, randomInRange, flag, thingDef});
				}
			}
			return false;
		}
	}

	[HarmonyPatch(typeof(BaseGenUtility), "RandomCheapWallStuff", new Type[] { typeof(TechLevel), typeof(bool) })]
	public static class BaseGenUtility_RandomCheapWallStuff {
		public static bool Prefix(TechLevel techLevel, ref ThingDef __result, bool notVeryFlammable = false) {
			if (techLevel.IsNeolithicOrWorse()) {
				__result = ThingDefOf.WoodLog;
				return false;
			}
			ThingDef wallType = (from wallStuff in DefDatabase<ThingDef>.AllDefsListForReading
			  where (!BaseGenUtility.IsCheapWallStuff(wallStuff) ? false : (!notVeryFlammable ? true : wallStuff.BaseFlammability < 0.5f))
			  select wallStuff).RandomElement<ThingDef>();
			Map map = BaseGen.globalSettings.map;
			if (Controller_Things.stoneTypeSetting < 0) {
				Controller_Things.stoneTypeSetting = Controller_Things.Settings.stoneType;
				if (Controller_Things.stoneTypeSetting > 3) {
					Controller_Things.stoneTypeSetting = (Rand.Value)*3;
				}
			}
			if (map == null || wallType.defName.Contains("Steel")
			  || Controller_Things.stoneTypeSetting < 1
			  || (Controller_Things.stoneTypeSetting < 2 && Rand.Value < 0.33)) {
				__result = wallType;
				return false;
			}
			ThingDef rockType = Find.World.NaturalRockTypesIn(map.Tile).RandomElement<ThingDef>();
			wallType = ThingDef.Named("Blocks"+rockType.defName);
			__result = wallType;
			return false;
		}
	}

	[HarmonyPatch(typeof(GenStep_Scatterer), "CountFromPer10kCells", null)]
	public static class GenStep_Scatterer_CountFromPer10kCells {
		public static bool Prefix(float countPer10kCells, Map map, ref int __result, int mapSize = -1) {
			if (mapSize < 0) {
				mapSize = map.Size.x;
			}
			//
			// Ore
			//
			if (countPer10kCells > 3.95) {
				float min = countPer10kCells;
				if (Controller_Terrain.oreLevelSetting < 0) {
					Controller_Terrain.oreLevelSetting = Controller_Terrain.Settings.oreLevel;
					if (Controller_Terrain.oreLevelSetting > 5) {
						Controller_Terrain.oreLevelSetting = (Rand.Value)*5;
					}
				}
				if (Controller_Terrain.oreLevelSetting < 1) { min = 0; }
				else if (Controller_Terrain.oreLevelSetting < 2) { min = min / 2; }
				else if (Controller_Terrain.oreLevelSetting < 3) { }
				else if (Controller_Terrain.oreLevelSetting < 4) { min = min * 2; }
				else { min = min * 4; }
				float max = min;
				countPer10kCells = Rand.Range(min, max);
			}
			//
			// Ruins
			//
			if (countPer10kCells > 1.95 && countPer10kCells < 3.85) {
				float min = 2;
				float max = 4;
				if (Controller_Things.ruinsLevelSetting < 0) {
					Controller_Things.ruinsLevelSetting = Controller_Things.Settings.ruinsLevel;
					if (Controller_Things.ruinsLevelSetting > 8) {
						Controller_Things.ruinsLevelSetting = (Rand.Value)*8;
					}
				}
				if (Controller_Things.ruinsLevelSetting < 1) { min = 0; max = 0; }
				else if (Controller_Things.ruinsLevelSetting < 2) { min = 0; max = 1; }
				else if (Controller_Things.ruinsLevelSetting < 3) { min = 1; max = 2; }
				else if (Controller_Things.ruinsLevelSetting < 4) { min = 2; max = 4; }
				else if (Controller_Things.ruinsLevelSetting < 5) { min = 4; max = 8; }
				else if (Controller_Things.ruinsLevelSetting < 6) { min = 8; max = 16; }
				else if (Controller_Things.ruinsLevelSetting < 7) { min = 16; max = 32; }
				else { min = 32; max = 64; }
				countPer10kCells = Rand.Range(min, max);
			}
			//
			// Geysers
			//
			if (countPer10kCells > 0.65 && countPer10kCells < 1.05) {
				float min = 0.7f;
				float max = 1;
				if (Controller_Terrain.geysersLevelSetting < 0) {
					Controller_Terrain.geysersLevelSetting = Controller_Terrain.Settings.geysersLevel;
					if (Controller_Terrain.geysersLevelSetting > 5) {
						Controller_Terrain.geysersLevelSetting = (Rand.Value)*5;
					}
				}
				if (Controller_Terrain.geysersLevelSetting < 1) { min = 0; max = 0; }
				else if (Controller_Terrain.geysersLevelSetting < 2) { min = 0.35f; max = 0.5f; }
				else if (Controller_Terrain.geysersLevelSetting < 3) { min = 0.7f; max = 1; }
				else if (Controller_Terrain.geysersLevelSetting < 4) { min = 1.4f; max = 2; }
				else { min = 2.8f; max = 4; }
				countPer10kCells = Rand.Range(min, max);
			}
			//
			// Shrines
			//
			if (countPer10kCells > 0.10 && countPer10kCells < 0.30) {
				float min = 0.12f;
				float max = 0.24f;
				if (Controller_Things.shrinesLevelSetting < 0) {
					Controller_Things.shrinesLevelSetting = Controller_Things.Settings.shrinesLevel;
					if (Controller_Things.shrinesLevelSetting > 8) {
						Controller_Things.shrinesLevelSetting = (Rand.Value)*8;
					}
				}
				if (Controller_Things.shrinesLevelSetting < 1) { min = 0; max = 0; }
				else if (Controller_Things.shrinesLevelSetting < 2) { min = 0; max = 0.06f; }
				else if (Controller_Things.shrinesLevelSetting < 3) { min = 0.06f; max = 0.12f; }
				else if (Controller_Things.shrinesLevelSetting < 4) { min = 0.12f; max = 0.24f; }
				else if (Controller_Things.shrinesLevelSetting < 5) { min = 0.24f; max = 0.48f; }
				else if (Controller_Things.shrinesLevelSetting < 6) { min = 0.48f; max = 0.96f; }
				else if (Controller_Things.shrinesLevelSetting < 7) { min = 0.96f; max = 1.92f; }
				else { min = 1.92f; max = 3.84f; }
				countPer10kCells = Rand.Range(min, max);
			}
			int num = Mathf.RoundToInt(10000f / countPer10kCells);
			__result = Mathf.RoundToInt((float)(mapSize * mapSize) / (float)num);
			return false;
		}
	}

	[HarmonyPatch(typeof(TerrainThreshold), "TerrainAtValue", null)]
	public static class TerrainThreshold_TerrainAtValue {
		public static bool Prefix(List<TerrainThreshold> threshes, float val, ref TerrainDef __result) {
			__result = null;
			if (threshes[0].min < -900) {
				//
				// TerrainsByFertility
				// 
				float mod = 0.0f;
				if (Controller_Terrain.fertilityLevelSetting < 0) {
					Controller_Terrain.fertilityLevelSetting = Controller_Terrain.Settings.fertilityLevel;
					if (Controller_Terrain.fertilityLevelSetting > 5) {
						Controller_Terrain.fertilityLevelSetting = (Rand.Value)*5;
					}
				}
				if (Controller_Terrain.fertilityLevelSetting < 1) { mod = 0.30f; }
				else if (Controller_Terrain.fertilityLevelSetting < 2) { mod = 0.15f; }
				else if (Controller_Terrain.fertilityLevelSetting < 3) { }
				else if (Controller_Terrain.fertilityLevelSetting < 4) { mod = -0.15f; }
				else { mod = -0.30f; }
				if (threshes[0].terrain.defName == "Soil") {
					float val1 = 0.87f + mod;
					if (val >= -999f && val < val1) { __result = TerrainDef.Named("Soil"); }
					else if (val >= val1 && val < 999f) { __result = TerrainDef.Named("SoilRich"); }
				}
				else if (threshes[0].terrain.defName == "Sand" && (threshes[0].max < 0.5f)) {
					float val1 = 0.90f + mod;
					if (val >= -999f && val < 0.45f) { __result = TerrainDef.Named("Sand"); }
					else if (val >= 0.45f && val < val1) { __result = TerrainDef.Named("Soil"); }
					else if (val >= val1 && val < 999f) { __result = TerrainDef.Named("SoilRich"); }
				}
				else {
					for (int i = 0; i < threshes.Count; i++) {
						if (threshes[i].min <= val && threshes[i].max > val) {
							__result = threshes[i].terrain;
						}
					}
				}
				return false;
			}
			//
			// TerrainPatchMakers
			//
			float adjustment = 0.0f;
			if (Controller_Terrain.waterLevelSetting < 0) {
				Controller_Terrain.waterLevelSetting = Controller_Terrain.Settings.waterLevel;
				if (Controller_Terrain.waterLevelSetting > 5) {
					Controller_Terrain.waterLevelSetting = (Rand.Value)*5;
				}
			}
			if (Controller_Terrain.waterLevelSetting < 1) { adjustment = 0.75f; }
			else if (Controller_Terrain.waterLevelSetting < 2) { adjustment = 0.33f; }
			else if (Controller_Terrain.waterLevelSetting < 3) { }
			else if (Controller_Terrain.waterLevelSetting < 4) { adjustment = -0.25f; }
			else { adjustment = -0.5f; }
			float richSoil = 0.0f;
			if (Controller_Terrain.fertilityLevelSetting < 0) {
				Controller_Terrain.fertilityLevelSetting = Controller_Terrain.Settings.fertilityLevel;
				if (Controller_Terrain.fertilityLevelSetting > 5) {
					Controller_Terrain.fertilityLevelSetting = (Rand.Value)*5;
				}
			}
			if (Controller_Terrain.fertilityLevelSetting < 1) { richSoil = -0.06f; }
			else if (Controller_Terrain.fertilityLevelSetting < 2) { richSoil = -0.03f; }
			else if (Controller_Terrain.fertilityLevelSetting < 3) { }
			else if (Controller_Terrain.fertilityLevelSetting < 4) { richSoil = 0.03f; }
			else { richSoil = 0.06f; }
			for (int i = 0; i < threshes.Count; i++) {
				if (threshes[0].terrain.defName == "SoilRich") {
					if (i == 0) {
						if ((threshes[i].min + adjustment) <= val && (threshes[i].max + adjustment + richSoil) > val) {
							__result = threshes[i].terrain;
						}
					}
					if (i == 1) {
						if ((threshes[i].min + adjustment + richSoil) <= val && (threshes[i].max + adjustment) > val) {
							__result = threshes[i].terrain;
						}
					}
					else {
						if ((threshes[i].min + adjustment) <= val && (threshes[i].max + adjustment) > val) {
							__result = threshes[i].terrain;
						}
					}
				}
				else {
					if ((threshes[i].min + adjustment) <= val && (threshes[i].max + adjustment) > val) {
						__result = threshes[i].terrain;
					}
				}
			}
			return false;
		}
	}

	[HarmonyPatch(typeof(GenStep_ElevationFertility), "Generate", null)]
	public static class GenStep_ElevationFertility_Generate {
        private const float ElevationFreq = 0.021f;
        private const float FertilityFreq = 0.021f;
        private const float EdgeMountainSpan = 0.42f;
		public static bool Prefix(Map map) {
			Rot4 random;
			NoiseRenderer.renderSize = new IntVec2(map.Size.x, map.Size.z);
			ModuleBase perlin = new Perlin(0.0209999997168779, 2, 0.5, 6, Rand.Range(0, 2147483647), QualityMode.High);
			perlin = new ScaleBias(0.5, 0.5, perlin);
			NoiseDebugUI.StoreNoiseRender(perlin, "elev base");
			float elevationFactorFlat = 1f;
			float elevationScale = 1f;
			switch (map.TileInfo.hilliness) {
				case Hilliness.Flat: {
					elevationFactorFlat = MapGenTuning.ElevationFactorFlat;
					elevationScale = 0.1f;
					break;
				}
				case Hilliness.SmallHills: {
					elevationFactorFlat = MapGenTuning.ElevationFactorSmallHills;
					elevationScale = 0.3f;
					break;
				}
				case Hilliness.LargeHills: {
					elevationFactorFlat = MapGenTuning.ElevationFactorLargeHills;
					elevationScale = 0.6f;
					break;
				}
				case Hilliness.Mountainous: {
					elevationFactorFlat = MapGenTuning.ElevationFactorMountains;
					break;
				}
				case Hilliness.Impassable: {
					elevationFactorFlat = MapGenTuning.ElevationFactorImpassableMountains;
					break;
				}
			}
			if (Controller_Terrain.mountainLevelSetting < 0) {
				Controller_Terrain.mountainLevelSetting = Controller_Terrain.Settings.mountainLevel;
				if (Controller_Terrain.mountainLevelSetting > 6) {
					Controller_Terrain.mountainLevelSetting = (Rand.Value)*6;
				}
			}
			if (Controller_Terrain.mountainLevelSetting < 1) {
				elevationFactorFlat -= (0.15f * elevationScale);
			}
			else if (Controller_Terrain.mountainLevelSetting < 2) {
				elevationFactorFlat -= (0.1f * elevationScale);
			}
			else if (Controller_Terrain.mountainLevelSetting < 3) { }
			else if (Controller_Terrain.mountainLevelSetting < 4) {
				elevationFactorFlat += (0.2f * elevationScale);
			}
			else if (Controller_Terrain.mountainLevelSetting < 5) {
				elevationFactorFlat += (0.6f * elevationScale);
			}
			else {
				elevationFactorFlat += (1.4f * elevationScale);
			}
			perlin = new Multiply(perlin, new Const((double)elevationFactorFlat));
			NoiseDebugUI.StoreNoiseRender(perlin, "elev world-factored");
			if (map.TileInfo.hilliness == Hilliness.Mountainous || map.TileInfo.hilliness == Hilliness.Impassable) {
				IntVec3 size = map.Size;
				ModuleBase distFromAxi = new DistFromAxis((float)size.x * 0.42f);
				distFromAxi = new Clamp(0, 1, distFromAxi);
				distFromAxi = new Invert(distFromAxi);
				distFromAxi = new ScaleBias(1, 1, distFromAxi);
				do {
					random = Rot4.Random;
				}
				while (random == Find.World.CoastDirectionAt(map.Tile));
				if (random == Rot4.North) {
					distFromAxi = new Rotate(0, 90, 0, distFromAxi);
					IntVec3 intVec3 = map.Size;
					distFromAxi = new Translate(0, 0, (double)(-intVec3.z), distFromAxi);
				}
				else if (random == Rot4.East) {
					IntVec3 size1 = map.Size;
					distFromAxi = new Translate((double)(-size1.x), 0, 0, distFromAxi);
				}
				else if (random == Rot4.South) {
					distFromAxi = new Rotate(0, 90, 0, distFromAxi);
				}
				else if (random == Rot4.West) { }
				NoiseDebugUI.StoreNoiseRender(distFromAxi, "mountain");
				perlin = new Add(perlin, distFromAxi);
				NoiseDebugUI.StoreNoiseRender(perlin, "elev + mountain");
			}
			float single = (!map.TileInfo.WaterCovered ? Single.MaxValue : 0f);
			MapGenFloatGrid elevation = MapGenerator.Elevation;
			foreach (IntVec3 allCell in map.AllCells) {
				elevation[allCell] = Mathf.Min(perlin.GetValue(allCell), single);
			}
			ModuleBase scaleBia = new Perlin(0.0209999997168779, 2, 0.5, 6, Rand.Range(0, 2147483647), QualityMode.High);
			scaleBia = new ScaleBias(0.5, 0.5, scaleBia);
			NoiseDebugUI.StoreNoiseRender(scaleBia, "noiseFert base");
			MapGenFloatGrid fertility = MapGenerator.Fertility;
			foreach (IntVec3 allCell1 in map.AllCells) {
				fertility[allCell1] = scaleBia.GetValue(allCell1);
			}
			return false;
		}
	}
    
	public class RFR_GenStep_Terrain : GenStep {
		private static bool debug_WarnedMissingTerrain;
		static RFR_GenStep_Terrain() {
			RFR_GenStep_Terrain.debug_WarnedMissingTerrain = false;
		}
		public RFR_GenStep_Terrain() { }
		public override void Generate(Map map) {
			RFR_BeachMaker.Init(map);
			RFR_RiverMaker riverMaker = this.GenerateRiver(map);
			List<IntVec3> intVec3s = new List<IntVec3>();
			MapGenFloatGrid elevation = MapGenerator.Elevation;
			MapGenFloatGrid fertility = MapGenerator.Fertility;
			MapGenFloatGrid caves = MapGenerator.Caves;
			TerrainGrid terrainGrid = map.terrainGrid;
			foreach (IntVec3 allCell in map.AllCells) {
				Building edifice = allCell.GetEdifice(map);
				TerrainDef terrainDef = null;
				terrainDef = ((edifice == null || edifice.def.Fillage != FillCategory.Full) && caves[allCell] <= 0f ? this.TerrainFrom(allCell, map, elevation[allCell], fertility[allCell], riverMaker, false) : this.TerrainFrom(allCell, map, elevation[allCell], fertility[allCell], riverMaker, true));
				if (terrainDef == TerrainDefOf.WaterMovingShallow || terrainDef == TerrainDefOf.WaterMovingDeep) {
					if (edifice != null) {
						intVec3s.Add(edifice.Position);
						edifice.Destroy(DestroyMode.Vanish);
					}
				}
				terrainGrid.SetTerrain(allCell, terrainDef);
			}
			if (riverMaker != null) {
				riverMaker.ValidatePassage(map);
			}
			RoofCollapseCellsFinder.RemoveBulkCollapsingRoofs(intVec3s, map);
			RFR_BeachMaker.Cleanup();
			foreach (TerrainPatchMaker terrainPatchMaker in map.Biome.terrainPatchMakers) {
				terrainPatchMaker.Cleanup();
			}
		}
		private RFR_RiverMaker GenerateRiver(Map map) {
			RFR_RiverMaker riverMaker;
			List<Tile.RiverLink> visibleRivers = Find.WorldGrid[map.Tile].VisibleRivers;
			if (visibleRivers == null || visibleRivers.Count == 0) {
				riverMaker = null;
			}
			else {
				WorldGrid worldGrid = Find.WorldGrid;
				int tile = map.Tile;
				Tile.RiverLink riverLink = (
				from rl in visibleRivers
				orderby -rl.river.degradeThreshold
				select rl).First<Tile.RiverLink>();
				float headingFromTo = worldGrid.GetHeadingFromTo(tile, riverLink.neighbor);
				float single = Rand.Range(0.3f, 0.7f) * (float)map.Size.x;
				float single1 = Rand.Range(0.3f, 0.7f);
				IntVec3 size = map.Size;
				Vector3 vector3 = new Vector3(single, 0f, single1 * (float)size.z);
				Vector3 vector31 = vector3;
				float single2 = headingFromTo;
				Tile.RiverLink riverLink1 = (
				from rl in visibleRivers
				orderby -rl.river.degradeThreshold
				select rl).FirstOrDefault<Tile.RiverLink>();
				RFR_RiverMaker riverMaker1 = new RFR_RiverMaker(vector31, single2, riverLink1.river);
				this.GenerateRiverLookupTexture(map, riverMaker1);
				riverMaker = riverMaker1;
			}
			return riverMaker;
		}
		private void GenerateRiverLookupTexture(Map map, RFR_RiverMaker riverMaker) {
			int num = Mathf.CeilToInt((
			from rd in DefDatabase<RiverDef>.AllDefs
			select rd.widthOnMap / 2f + 5f).Max());
			int num1 = Mathf.Max(4, num) * 2;
			Dictionary<int, RFR_GenStep_Terrain.GRLT_Entry> nums = new Dictionary<int, RFR_GenStep_Terrain.GRLT_Entry>();
			Dictionary<int, RFR_GenStep_Terrain.GRLT_Entry> nums1 = new Dictionary<int, RFR_GenStep_Terrain.GRLT_Entry>();
			Dictionary<int, RFR_GenStep_Terrain.GRLT_Entry> nums2 = new Dictionary<int, RFR_GenStep_Terrain.GRLT_Entry>();
			for (int i = -num1; i < map.Size.z + num1; i++) {
				for (int j = -num1; j < map.Size.x + num1; j++) {
					IntVec3 intVec3 = new IntVec3(j, 0, i);
					Vector3 vector3 = riverMaker.WaterCoordinateAt(intVec3);
					int num2 = Mathf.FloorToInt(vector3.z / 4f);
					this.UpdateRiverAnchorEntry(nums, intVec3, num2, (vector3.z + Mathf.Abs(vector3.x)) / 4f);
					this.UpdateRiverAnchorEntry(nums1, intVec3, num2, (vector3.z + Mathf.Abs(vector3.x - (float)num)) / 4f);
					this.UpdateRiverAnchorEntry(nums2, intVec3, num2, (vector3.z + Mathf.Abs(vector3.x + (float)num)) / 4f);
				}
			}
			int num3 = Mathf.Max(new int[] { nums.Keys.Min(), nums1.Keys.Min(), nums2.Keys.Min() });
			int num4 = Mathf.Min(new int[] { nums.Keys.Max(), nums1.Keys.Max(), nums2.Keys.Max() });
			for (int k = num3; k < num4; k++) {
				WaterInfo waterInfo = map.waterInfo;
				if (nums1.ContainsKey(k) && nums1.ContainsKey(k + 1)) {
					waterInfo.riverDebugData.Add(nums1[k].bestNode.ToVector3Shifted());
					List<Vector3> vector3s = waterInfo.riverDebugData;
					RFR_GenStep_Terrain.GRLT_Entry item = nums1[k + 1];
					vector3s.Add(item.bestNode.ToVector3Shifted());
				}
				if (nums.ContainsKey(k) && nums.ContainsKey(k + 1)) {
					waterInfo.riverDebugData.Add(nums[k].bestNode.ToVector3Shifted());
					List<Vector3> vector3s1 = waterInfo.riverDebugData;
					RFR_GenStep_Terrain.GRLT_Entry gRLTEntry = nums[k + 1];
					vector3s1.Add(gRLTEntry.bestNode.ToVector3Shifted());
				}
				if (nums2.ContainsKey(k) && nums2.ContainsKey(k + 1)) {
					waterInfo.riverDebugData.Add(nums2[k].bestNode.ToVector3Shifted());
					List<Vector3> vector3s2 = waterInfo.riverDebugData;
					RFR_GenStep_Terrain.GRLT_Entry item1 = nums2[k + 1];
					vector3s2.Add(item1.bestNode.ToVector3Shifted());
				}
				if (nums1.ContainsKey(k) && nums.ContainsKey(k)) {
					waterInfo.riverDebugData.Add(nums1[k].bestNode.ToVector3Shifted());
					waterInfo.riverDebugData.Add(nums[k].bestNode.ToVector3Shifted());
				}
				if (nums.ContainsKey(k) && nums2.ContainsKey(k)) {
					waterInfo.riverDebugData.Add(nums[k].bestNode.ToVector3Shifted());
					waterInfo.riverDebugData.Add(nums2[k].bestNode.ToVector3Shifted());
				}
			}
			IntVec3 size = map.Size;
			IntVec3 size1 = map.Size;
			CellRect cellRect = new CellRect(-2, -2, size.x + 4, size1.z + 4);
			float[] singleArray = new float[cellRect.Area * 2];
			int num5 = 0;
			for (int l = cellRect.minZ; l <= cellRect.maxZ; l++) {
				for (int m = cellRect.minX; m <= cellRect.maxX; m++) {
					IntVec3 intVec31 = new IntVec3(m, 0, l);
					bool flag = true;
					int num6 = 0;
					while (num6 < (int)GenAdj.AdjacentCellsAndInside.Length) {
						if (riverMaker.TerrainAt(intVec31 + GenAdj.AdjacentCellsAndInside[num6], false) == null) {
							num6++;
						}
						else {
							flag = false;
							break;
						}
					}
					if (!flag) {
						Vector2 vector2 = intVec31.ToIntVec2.ToVector2();
						int num7 = -2147483648;
						Vector2 vector21 = Vector2.zero;
						int num8 = num3;
						while (num8 < num4) {
							Vector2 vector22 = nums1[num8].bestNode.ToIntVec2.ToVector2();
							RFR_GenStep_Terrain.GRLT_Entry gRLTEntry1 = nums1[num8 + 1];
							Vector2 vector23 = gRLTEntry1.bestNode.ToIntVec2.ToVector2();
							Vector2 vector24 = nums[num8].bestNode.ToIntVec2.ToVector2();
							RFR_GenStep_Terrain.GRLT_Entry item2 = nums[num8 + 1];
							Vector2 vector25 = item2.bestNode.ToIntVec2.ToVector2();
							Vector2 vector26 = nums2[num8].bestNode.ToIntVec2.ToVector2();
							RFR_GenStep_Terrain.GRLT_Entry gRLTEntry2 = nums2[num8 + 1];
							Vector2 vector27 = gRLTEntry2.bestNode.ToIntVec2.ToVector2();
							Vector2 vector28 = GenGeo.InverseQuadBilinear(vector2, vector24, vector22, vector25, vector23);
							if (vector28.x < -0.0001f || vector28.x > 1.0001f || vector28.y < -0.0001f || vector28.y > 1.0001f) {
								Vector2 vector29 = GenGeo.InverseQuadBilinear(vector2, vector24, vector26, vector25, vector27);
								if (vector29.x < -0.0001f || vector29.x > 1.0001f || vector29.y < -0.0001f || vector29.y > 1.0001f) {
									num8++;
								}
								else {
									vector21 = new Vector2(vector29.x * (float)num, (vector29.y + (float)num8) * 4f);
									num7 = num8;
									break;
								}
							}
							else {
								vector21 = new Vector2(-vector28.x * (float)num, (vector28.y + (float)num8) * 4f);
								num7 = num8;
								break;
							}
						}
						if (num7 == -2147483648) {
							Log.ErrorOnce("Failed to find all necessary river flow data", 5273133);
						}
						singleArray[num5] = vector21.x;
						singleArray[num5 + 1] = vector21.y;
					}
					num5 += 2;
				}
			}
			float[] singleArray1 = new float[cellRect.Area * 2];
			float[] singleArray2 = new float[] { 0.123317f, 0.123317f, 0.123317f, 0.123317f, 0.077847f, 0.077847f, 0.077847f, 0.077847f, 0.195346f };
			int num9 = 0;
			for (int n = cellRect.minZ; n <= cellRect.maxZ; n++) {
				for (int o = cellRect.minX; o <= cellRect.maxX; o++) {
					IntVec3 intVec32 = new IntVec3(o, 0, n);
					float single = 0f;
					float single1 = 0f;
					float single2 = 0f;
					for (int p = 0; p < (int)GenAdj.AdjacentCellsAndInside.Length; p++) {
						if (cellRect.Contains(intVec32 + GenAdj.AdjacentCellsAndInside[p])) {
							int adjacentCellsAndInside = num9 + (GenAdj.AdjacentCellsAndInside[p].x + GenAdj.AdjacentCellsAndInside[p].z * cellRect.Width) * 2;
							if ((int)singleArray.Length <= adjacentCellsAndInside + 1 || adjacentCellsAndInside < 0) {
								Log.Message("you wut");
							}
							if (singleArray[adjacentCellsAndInside] != 0f || singleArray[adjacentCellsAndInside + 1] != 0f) {
								single = single + singleArray[adjacentCellsAndInside] * singleArray2[p];
								single1 = single1 + singleArray[adjacentCellsAndInside + 1] * singleArray2[p];
								single2 += singleArray2[p];
							}
						}
					}
					if (single2 > 0f) {
						singleArray1[num9] = single / single2;
						singleArray1[num9 + 1] = single1 / single2;
					}
					num9 += 2;
				}
			}
			singleArray = singleArray1;
			for (int q = 0; q < (int)singleArray.Length; q += 2) {
				if (singleArray[q] != 0f || singleArray[q + 1] != 0f) {
					Vector3 pointOnDisc = Rand.PointOnDisc * 0.4f;
					singleArray[q] += pointOnDisc.x;
					singleArray[q + 1] += pointOnDisc.z;
				}
			}
			byte[] numArray = new byte[(int)singleArray.Length * 4];
			Buffer.BlockCopy(singleArray, 0, numArray, 0, (int)singleArray.Length * 4);
			map.waterInfo.riverOffsetMap = numArray;
			map.waterInfo.GenerateRiverFlowMap();
		}
		private TerrainDef TerrainFrom(IntVec3 c, Map map, float elevation, float fertility, RFR_RiverMaker river, bool preferSolid) {
			if (map.Biome.defName.Contains("Archipelago")) {
				//
				// Coast Level (for Islands)
				//
				float adjustment = 0.0f;
				if (Controller_Terrain.coastLevelSetting < 0) {
					Controller_Terrain.coastLevelSetting = Controller_Terrain.Settings.coastLevel;
					if (Controller_Terrain.coastLevelSetting > 7) {
						Controller_Terrain.coastLevelSetting = (Rand.Value)*7;
					}
				}
				if (Controller_Terrain.coastLevelSetting < 1) { }
				else if (Controller_Terrain.coastLevelSetting < 2) { adjustment = 0.02f; }
				else if (Controller_Terrain.coastLevelSetting < 3) { adjustment = 0.04f; }
				else if (Controller_Terrain.coastLevelSetting < 4) { adjustment = 0.06f; }
				else if (Controller_Terrain.coastLevelSetting < 5) { adjustment = 0.08f; }
				else if (Controller_Terrain.coastLevelSetting < 6) { adjustment = 0.10f; }
				else { adjustment = 0.12f; }
				bool lakeIsles = false;
				if (map.Biome.defName.Contains("_Fresh")) { lakeIsles = true; }
				if (elevation < 0.75f) {
					Building edifice = c.GetEdifice(map);
					if (edifice != null) { edifice.Destroy(DestroyMode.Vanish); }
					map.roofGrid.SetRoof(c, null);
					for (int i = -1; i < 2; i++) {
						for (int j = -1; j < 2; j++) {
							int x = c.x + i;
							int z = c.z + j;
							if (x >= 0 && z >= 0 && x < map.Size.x && z < map.Size.z) {
								IntVec3 newSpot = new IntVec3(x, 0, z);
								if (map.roofGrid.RoofAt(newSpot) != null) {
									if (map.roofGrid.RoofAt(newSpot).isThickRoof) {
										map.roofGrid.SetRoof(newSpot, RoofDefOf.RoofRockThin);
									}
									else {
										if ((i == 0 && j != 0) || (i != 0 && j == 0)) {
											if (Rand.Value < 0.33) {
												map.roofGrid.SetRoof(newSpot, null);
											}
										}
									}
								}
							}
						}
					}
				}
				if (elevation > 0.65f && elevation <= 0.69f) {
					return TerrainDefOf.Gravel;
				}
				if (elevation > 0.69f & elevation < 0.71f) {
					if (Controller_Terrain.detectedFertileFields.Equals(true)) {
						return TerrainDef.Named("RockySoil");
					}
					return TerrainDefOf.Gravel;
				}
				if (elevation >= 0.71f) {
					return GenStep_RocksFromGrid.RockDefAt(c).naturalTerrain;
				}
				TerrainDef deepWater = TerrainDefOf.WaterOceanDeep;
				TerrainDef shallowWater = TerrainDefOf.WaterOceanShallow;
				if (lakeIsles.Equals(true)) {
					deepWater = TerrainDefOf.WaterDeep;
					shallowWater = TerrainDefOf.WaterShallow;
				}
				if (elevation < (0.40f+adjustment)) {
					return deepWater;
				}
				if (elevation < (0.45f+adjustment)) {
					return shallowWater;
				}
				TerrainDef borderTerrainL = TerrainDefOf.Sand;
				TerrainDef borderTerrainH = TerrainDefOf.Sand;
				if (lakeIsles.Equals(true)) {
					if (map.Biome.defName.Contains("Boreal") || map.Biome.defName.Contains("Tundra")) {
						borderTerrainL = TerrainDef.Named("Mud");
						borderTerrainH = TerrainDef.Named("MossyTerrain");
					}
					else if (map.Biome.defName.Contains("ColdBog") || map.Biome.defName.Contains("Swamp")) {
						borderTerrainL = TerrainDef.Named("Marsh");
						borderTerrainH = TerrainDef.Named("MarshyTerrain");
					}
					else if (map.Biome.defName.Contains("Temperate") || map.Biome.defName.Contains("Tropical")) {
						borderTerrainL = TerrainDef.Named("Mud");
						borderTerrainH = TerrainDef.Named("SoilRich");
					}
				}
				if (elevation < 0.47f) {
					return borderTerrainL;
				}
				if (elevation < 0.50f) {
					return borderTerrainH;
				}
				TerrainDef terrainDefA = TerrainThreshold.TerrainAtValue(map.Biome.terrainsByFertility, fertility);
				if (terrainDefA != null) {
					return terrainDefA;
				}
				return borderTerrainH;
			}
			TerrainDef terrainDef = null;
			if (river != null) {
				terrainDef = river.TerrainAt(c, true);
			}
			TerrainDef terrainDef1 = RFR_BeachMaker.BeachTerrainAt(c, map, map.Biome);
			TerrainDef terrainDef2 = null;
			for (int i = 0; i < map.Biome.terrainPatchMakers.Count; i++) {
				terrainDef2 = map.Biome.terrainPatchMakers[i].TerrainAt(c, map);
				if (terrainDef2 != null) {
					break;
				}
			}
			if (terrainDef == null && preferSolid) {
				if (Controller_Terrain.Settings.disallowIslands.Equals(false) || (terrainDef1 == null && terrainDef2 == null)) {
					return GenStep_RocksFromGrid.RockDefAt(c).naturalTerrain;
				}
				Building edifice = c.GetEdifice(map);
				if (edifice != null) { edifice.Destroy(DestroyMode.Vanish); }
				map.roofGrid.SetRoof(c, null);
				for (int i = -1; i < 2; i++) {
					for (int j = -1; j < 2; j++) {
						int x = c.x + i;
						int z = c.z + j;
						if (x >= 0 && z >= 0 && x < map.Size.x && z < map.Size.z) {
							IntVec3 newSpot = new IntVec3(x, 0, z);
							if (map.roofGrid.RoofAt(newSpot) != null) {
								if (map.roofGrid.RoofAt(newSpot).isThickRoof) {
									map.roofGrid.SetRoof(newSpot, RoofDefOf.RoofRockThin);
								}
								else {
									if ((i == 0 && j != 0) || (i != 0 && j == 0)) {
										if (Rand.Value < 0.33) {
											map.roofGrid.SetRoof(newSpot, null);
										}
									}
								}
							}
						}
					}
				}
			}
			if (terrainDef1 == TerrainDefOf.WaterOceanDeep) {
				return terrainDef1;
			}
			if (terrainDef == TerrainDefOf.WaterMovingShallow || terrainDef == TerrainDefOf.WaterMovingDeep) {
				return terrainDef;
			}
			if (terrainDef1 != null) {
				//
				// Lake water has priority over beach sand
				//
				if (terrainDef1.defName.Contains("Sand")) {
					if ((terrainDef2 != null) && terrainDef2.defName.Contains("Water")) { }
					else {
						return terrainDef1;
					}
				}
				else {
					return terrainDef1;
				}
			}
			if (terrainDef != null) {
				return terrainDef;
			}
			if (terrainDef2 != null) {
				return terrainDef2;
			}
			if (elevation > 0.55f && elevation <= 0.59f) {
				return TerrainDefOf.Gravel;
			}
			if (elevation > 0.59f & elevation < 0.61f) {
				if (Controller_Terrain.detectedFertileFields.Equals(true)) {
					return TerrainDef.Named("RockySoil");
				}
				return TerrainDefOf.Gravel;
			}
			if (elevation >= 0.61f) {
				return GenStep_RocksFromGrid.RockDefAt(c).naturalTerrain;
			}
			terrainDef1 = TerrainThreshold.TerrainAtValue(map.Biome.terrainsByFertility, fertility);
			if (terrainDef1 != null) {
				return terrainDef1;
			}
			if (!RFR_GenStep_Terrain.debug_WarnedMissingTerrain) {
				Log.Error(string.Concat(new object[] { "No terrain found in biome ", map.Biome.defName, " for elevation=", elevation, ", fertility=", fertility }));
				RFR_GenStep_Terrain.debug_WarnedMissingTerrain = true;
			}
			return TerrainDefOf.Sand;
		}
		private void UpdateRiverAnchorEntry(Dictionary<int, RFR_GenStep_Terrain.GRLT_Entry> entries, IntVec3 center, int entryId, float zValue) {
			float single = zValue - (float)entryId;
			if (single <= 2f) {
				if (!entries.ContainsKey(entryId) || entries[entryId].bestDistance > single) {
					RFR_GenStep_Terrain.GRLT_Entry gRLTEntry = new RFR_GenStep_Terrain.GRLT_Entry() {
						bestDistance = single,
						bestNode = center
					};
					entries[entryId] = gRLTEntry;
				}
			}
		}
		private struct GRLT_Entry {
			public float bestDistance;
			public IntVec3 bestNode;
		}
	}

	internal static class RFR_BeachMaker {
		private const float PerlinFrequency = 0.03f;
		private const float MaxForDeepWater = 0.1f;
		private const float MaxForShallowWater = 0.45f;
		private const float MaxForSand = 1f;
		private static ModuleBase beachNoise;
		private readonly static FloatRange CoastWidthRange;
		static RFR_BeachMaker() {
			RFR_BeachMaker.CoastWidthRange = new FloatRange(20f, 60f);
		}
		public static TerrainDef BeachTerrainAt(IntVec3 loc, Map map, BiomeDef biome) {
			//
			// Coast Level
			//
			float adjustment = 0.0f;
			if (Controller_Terrain.coastLevelSetting < 0) {
				Controller_Terrain.coastLevelSetting = Controller_Terrain.Settings.coastLevel;
				if (Controller_Terrain.coastLevelSetting > 7) {
					Controller_Terrain.coastLevelSetting = (Rand.Value)*7;
				}
			}
			if (Controller_Terrain.coastLevelSetting < 1) { }
			else if (Controller_Terrain.coastLevelSetting < 2) { adjustment = 0.5f; }
			else if (Controller_Terrain.coastLevelSetting < 3) { adjustment = 1.0f; }
			else if (Controller_Terrain.coastLevelSetting < 4) { adjustment = 1.5f; }
			else if (Controller_Terrain.coastLevelSetting < 5) { adjustment = 2.0f; }
			else if (Controller_Terrain.coastLevelSetting < 6) { adjustment = 2.5f; }
			else { adjustment = 3.0f; }
			if (RFR_BeachMaker.beachNoise == null) {
				return null;
			}
			float value = RFR_BeachMaker.beachNoise.GetValue(loc);
			if (value < (0.1f + adjustment)) {
				return TerrainDefOf.WaterOceanDeep;
			}
			if (value < (0.45f + adjustment)) {
				return TerrainDefOf.WaterOceanShallow;
			}
			if (value >= (1f + adjustment)) {
				return null;
			}
			return (biome != BiomeDefOf.SeaIce ? TerrainDefOf.Sand : TerrainDefOf.Ice);
		}
		public static void Cleanup() {
			RFR_BeachMaker.beachNoise = null;
		}
		public static void Init(Map map) {
			Rot4 rot4 = Find.World.CoastDirectionAt(map.Tile);
			if (!rot4.IsValid) {
				RFR_BeachMaker.beachNoise = null;
				return;
			}
			ModuleBase perlin = new Perlin(0.0299999993294477, 2, 0.5, 3, Rand.Range(0, 2147483647), QualityMode.Medium);
			perlin = new ScaleBias(0.5, 0.5, perlin);
			int size = map.Size.x;
			IntVec3 intVec3 = map.Size;
			NoiseDebugUI.StoreNoiseRender(perlin, "BeachMaker base", new IntVec2(size, intVec3.z));
			ModuleBase distFromAxi = new DistFromAxis(RFR_BeachMaker.CoastWidthRange.RandomInRange);
			if (rot4 == Rot4.North) {
				distFromAxi = new Rotate(0, 90, 0, distFromAxi);
				IntVec3 size1 = map.Size;
				distFromAxi = new Translate(0, 0, (double)(-size1.z), distFromAxi);
			}
			else if (rot4 == Rot4.East) {
				IntVec3 intVec31 = map.Size;
				distFromAxi = new Translate((double)(-intVec31.x), 0, 0, distFromAxi);
			}
			else if (rot4 == Rot4.South) {
				distFromAxi = new Rotate(0, 90, 0, distFromAxi);
			}
			distFromAxi = new ScaleBias(1, -1, distFromAxi);
			distFromAxi = new Clamp(-1, 2.5, distFromAxi);
			NoiseDebugUI.StoreNoiseRender(distFromAxi, "BeachMaker axis bias");
			RFR_BeachMaker.beachNoise = new Add(perlin, distFromAxi);
			NoiseDebugUI.StoreNoiseRender(RFR_BeachMaker.beachNoise, "beachNoise");
		}
	}

	internal class RFR_RiverMaker {
		private ModuleBase generator;
		private ModuleBase coordinateX;
		private ModuleBase coordinateZ;
		private ModuleBase shallowizer;
		private float surfaceLevel;
		private float shallowFactor = 0.2f;
		private List<IntVec3> lhs = new List<IntVec3>();
		private List<IntVec3> rhs = new List<IntVec3>();
		private float fordability;
		public RFR_RiverMaker(Vector3 center, float angle, RiverDef riverDef) {
			//
			// Water Level (for Rivers)
			//
			if (riverDef.widthOnMap > 9) { fordability = 0.05f; }
			else if (riverDef.widthOnMap > 7) { fordability = 0.1f; }
			else if (riverDef.widthOnMap > 5) { fordability = 0.15f; }
			else { fordability = 0.2f; }
			this.surfaceLevel = riverDef.widthOnMap / 2f;
			if (Controller_Terrain.waterLevelSetting < 0) {
				Controller_Terrain.waterLevelSetting = Controller_Terrain.Settings.waterLevel;
				if (Controller_Terrain.waterLevelSetting > 5) {
					Controller_Terrain.waterLevelSetting = (Rand.Value)*5;
				}
			}
			if (Controller_Terrain.waterLevelSetting < 1) {
				this.surfaceLevel = this.surfaceLevel * 0.8f;
				this.fordability = this.fordability * 1.2f;
			}
			else if (Controller_Terrain.waterLevelSetting < 2) {
				this.surfaceLevel = this.surfaceLevel * 0.9f;
				this.fordability = this.fordability * 1.1f;
			}
			else if (Controller_Terrain.waterLevelSetting < 3) { }
			else if (Controller_Terrain.waterLevelSetting < 4) { 
				this.surfaceLevel = this.surfaceLevel * 1.1f;
				this.fordability = this.fordability * 0.9f;
			}
			else { 
				this.surfaceLevel = this.surfaceLevel * 1.2f;
				this.fordability = this.fordability * 0.8f;
			}
			this.coordinateX = new AxisAsValueX();
			this.coordinateZ = new AxisAsValueZ();
			this.coordinateX = new Rotate(0, (double)(-angle), 0, this.coordinateX);
			this.coordinateZ = new Rotate(0, (double)(-angle), 0, this.coordinateZ);
			this.coordinateX = new Translate((double)(-center.x), 0, (double)(-center.z), this.coordinateX);
			this.coordinateZ = new Translate((double)(-center.x), 0, (double)(-center.z), this.coordinateZ);
			ModuleBase perlin = new Perlin(0.0299999993294477, 2, 0.5, 3, Rand.Range(0, 2147483647), QualityMode.Medium);
			ModuleBase multiply = new Perlin(0.0299999993294477, 2, 0.5, 3, Rand.Range(0, 2147483647), QualityMode.Medium);
			ModuleBase @const = new Const(8);
			perlin = new Multiply(perlin, @const);
			multiply = new Multiply(multiply, @const);
			this.coordinateX = new Displace(this.coordinateX, perlin, new Const(0), multiply);
			this.coordinateZ = new Displace(this.coordinateZ, perlin, new Const(0), multiply);
			this.generator = this.coordinateX;
			this.shallowizer = new Perlin(0.0299999993294477, 2, 0.5, 3, Rand.Range(0, 2147483647), QualityMode.Medium);
			this.shallowizer = new Abs(this.shallowizer);
		}
		public TerrainDef TerrainAt(IntVec3 loc, bool recordForValidation = false) {
			float value = this.generator.GetValue(loc);
			float single = this.surfaceLevel - Mathf.Abs(value);
			if (single > 2f && this.shallowizer.GetValue(loc) > this.fordability) {
				return TerrainDefOf.WaterMovingDeep;
			}
			if (single <= 0f) {
				return null;
			}
			if (recordForValidation) {
				if (value >= 0f) {
					this.rhs.Add(loc);
				}
				else {
					this.lhs.Add(loc);
				}
			}
			return TerrainDefOf.WaterMovingShallow;
		}
		public void ValidatePassage(Map map) {
			IntVec3 intVec3 = (
			from loc in this.lhs
			where (!loc.InBounds(map) ? false : loc.GetTerrain(map) == TerrainDefOf.WaterMovingShallow)
			select loc).RandomElementWithFallback<IntVec3>(IntVec3.Invalid);
			IntVec3 intVec31 = (
			from loc in this.rhs
			where (!loc.InBounds(map) ? false : loc.GetTerrain(map) == TerrainDefOf.WaterMovingShallow)
			select loc).RandomElementWithFallback<IntVec3>(IntVec3.Invalid);
			if (intVec3 == IntVec3.Invalid || intVec31 == IntVec3.Invalid) {
				Log.Error("Failed to find river edges in order to verify passability");
			}
			else {
				while (!map.reachability.CanReach(intVec3, intVec31, PathEndMode.OnCell, TraverseMode.PassAllDestroyableThings)) {
					if (this.shallowFactor <= 1f) {
						this.shallowFactor += 0.1f;
						foreach (IntVec3 allCell in map.AllCells) {
							if (allCell.GetTerrain(map) == TerrainDefOf.WaterMovingDeep && this.shallowizer.GetValue(allCell) <= this.shallowFactor) {
								map.terrainGrid.SetTerrain(allCell, TerrainDefOf.WaterMovingShallow);
							}
						}
					}
					else {
						Log.Error("Failed to make river shallow enough for passability");
						break;
					}
				}
			}
		}
		public Vector3 WaterCoordinateAt(IntVec3 loc) {
			Vector3 vector3 = new Vector3(this.coordinateX.GetValue(loc), 0f, this.coordinateZ.GetValue(loc));
			return vector3;
		}
	}

	[HarmonyPatch(typeof(World), "NaturalRockTypesIn", null)]
	public static class World_NaturalRockTypesIn {
		public static bool Prefix(int tile, ref List<ThingDef> __result) {
			Rand.PushState();
			Rand.Seed = tile;
			List<ThingDef> list = (
				from d in DefDatabase<ThingDef>.AllDefs
				where (d.category != ThingCategory.Building || !d.building.isNaturalRock ? false : !d.building.isResourceRock)
				select d).ToList<ThingDef>();
			int count = Rand.RangeInclusive((int)Controller_World.Settings.stoneMin, (int)Controller_World.Settings.stoneMax);
			if (count > list.Count) {
				count = list.Count;
			}
			List<ThingDef> thingDefs = new List<ThingDef>();
			for (int i = 0; i < count; i++) {
				ThingDef thingDef = list.RandomElement<ThingDef>();
				if (thingDef.defName == "Granite") { 
					if (Controller_World.Settings.graniteCommonality < 1) {
						if (Rand.Value < 0.90) { i--; continue; }
					}
					if (Controller_World.Settings.graniteCommonality < 2) {
						if (Rand.Value < 0.45) { i--; continue; }
					}
				}
				else if (thingDef.defName == "Limestone") { 
					if (Controller_World.Settings.limestoneCommonality < 1) {
						if (Rand.Value < 0.90) { i--; continue; }
					}
					if (Controller_World.Settings.limestoneCommonality < 2) {
						if (Rand.Value < 0.45) { i--; continue; }
					}
				}
				else if (thingDef.defName == "Marble") { 
					if (Controller_World.Settings.marbleCommonality < 1) {
						if (Rand.Value < 0.90) { i--; continue; }
					}
					if (Controller_World.Settings.marbleCommonality < 2) {
						if (Rand.Value < 0.45) { i--; continue; }
					}
				}
				else if (thingDef.defName == "Sandstone") { 
					if (Controller_World.Settings.sandstoneCommonality < 1) {
						if (Rand.Value < 0.90) { i--; continue; }
					}
					if (Controller_World.Settings.sandstoneCommonality < 2) {
						if (Rand.Value < 0.45) { i--; continue; }
					}
				}
				else if (thingDef.defName == "Slate") { 
					if (Controller_World.Settings.slateCommonality < 1) {
						if (Rand.Value < 0.90) { i--; continue; }
					}
					if (Controller_World.Settings.slateCommonality < 2) {
						if (Rand.Value < 0.45) { i--; continue; }
					}
				}
				else { 
					if (Controller_World.Settings.extraStoneCommonality < 1) {
						if (Rand.Value < 0.90) { i--; continue; }
					}
					if (Controller_World.Settings.extraStoneCommonality < 2) {
						if (Rand.Value < 0.45) { i--; continue; }
					}
				}
				list.Remove(thingDef);
				thingDefs.Add(thingDef);
			}
			Rand.PopState();
			__result = thingDefs;
			return false;
		}
	}

}
